﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
''' 此类用于存储计数器，以及定义
''' ToString() 方法，该方法可由 ComboBox
''' 用来显示计数器的实例和名称。
''' </summary>
''' <remarks></remarks>
Public Class CounterDisplayItem
    ' 在类中存储计数器的实例。
    Private counterValue As PerformanceCounter

    ' 定义一个构造函数，该构造函数要求传递 PerformanceCounter。
    ' 存储传递的计数器。
    Public Sub New(ByVal inCounter As PerformanceCounter)
        ' 仅当传递的值的确是计数器时，才存储该值。
        If TypeName(inCounter) = "PerformanceCounter" Then
            counterValue = inCounter
        Else
            counterValue = Nothing
        End If
    End Sub

    ' 此属性获取或设置由 CounterDisplayItem 对象
    ' 存储的 PerformanceCounter。
    Public Property Counter() As PerformanceCounter
        Get
            Return counterValue
        End Get
        Set(ByVal Value As PerformanceCounter)
            counterValue = Value
        End Set
    End Property

    ' 此函数重写 ToString() 方法以显示
    ' 用户选择正确计数器所必需
    ' 的有关 Counter 的信息。
    Public Overrides Function ToString() As String
        If counterValue IsNot Nothing Then
            Return counterValue.InstanceName + " - " + counterValue.CounterName
        Else
            Return ""
        End If
    End Function

    ' 如果计数器是自定义计数器，则此属性返回 True， 
    ' 否则返回 False。由于 PerformanceCounter 对象不存在
    ' IsCustom 属性，因此使用一小段特殊代码。此代码
    ' 尝试将 ReadOnly 属性设置为 False，然后从计数器读取
    ' 一个值。如果计数器不是自定义计数器，则会引发异常，
    ' 否则不会引发异常。
    Public ReadOnly Property IsCustom() As Boolean
        Get
            ' 存储 ReadOnly 属性的当前值
            Dim isReadOnly As Boolean = counterValue.ReadOnly
            Try
                ' 如果 ReadOnly 为 False，则仅当 Counter
                '是自定义计数器时，NextValue 才会有效。
                ' 遗憾的是，PerformanceCounter 对象中
                ' 没有任何属性已返回
                ' 计数器是否为自定义的。
                counterValue.ReadOnly = False
                counterValue.NextValue()
                ' 如果 NextValue 有效，则为自定义计数器。
                Return True
            Catch exc As Exception
                ' 这不是自定义计数器。
                Return False
            Finally
                ' 将值重置为前一个值。
                counterValue.ReadOnly = isReadOnly
            End Try
        End Get
    End Property
End Class
